<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidManagement;

class ManagedPropertyEntry extends \Google\Model
{
  /**
   * The human-readable name of the value. Localized.
   *
   * @var string
   */
  public $name;
  /**
   * The machine-readable value of the entry, which should be used in the
   * configuration. Not localized.
   *
   * @var string
   */
  public $value;

  /**
   * The human-readable name of the value. Localized.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The machine-readable value of the entry, which should be used in the
   * configuration. Not localized.
   *
   * @param string $value
   */
  public function setValue($value)
  {
    $this->value = $value;
  }
  /**
   * @return string
   */
  public function getValue()
  {
    return $this->value;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ManagedPropertyEntry::class, 'Google_Service_AndroidManagement_ManagedPropertyEntry');
