<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class ZoneSetLabelsRequest extends \Google\Model
{
  /**
   * The fingerprint of the previous set of labels for this resource, used to
   * detect conflicts. The fingerprint is initially generated by Compute Engine
   * and changes after every request to modify or update labels. You must always
   * provide an up-to-date fingerprint hash in order to update or change labels.
   * Make a get() request to the resource to get the latest fingerprint.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * The labels to set for this resource.
   *
   * @var string[]
   */
  public $labels;

  /**
   * The fingerprint of the previous set of labels for this resource, used to
   * detect conflicts. The fingerprint is initially generated by Compute Engine
   * and changes after every request to modify or update labels. You must always
   * provide an up-to-date fingerprint hash in order to update or change labels.
   * Make a get() request to the resource to get the latest fingerprint.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * The labels to set for this resource.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ZoneSetLabelsRequest::class, 'Google_Service_Compute_ZoneSetLabelsRequest');
