<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\GamesConfiguration;

class LocalizedStringBundle extends \Google\Collection
{
  protected $collection_key = 'translations';
  /**
   * Uniquely identifies the type of this resource. Value is always the fixed
   * string `gamesConfiguration#localizedStringBundle`.
   *
   * @var string
   */
  public $kind;
  protected $translationsType = LocalizedString::class;
  protected $translationsDataType = 'array';

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed
   * string `gamesConfiguration#localizedStringBundle`.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * The locale strings.
   *
   * @param LocalizedString[] $translations
   */
  public function setTranslations($translations)
  {
    $this->translations = $translations;
  }
  /**
   * @return LocalizedString[]
   */
  public function getTranslations()
  {
    return $this->translations;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LocalizedStringBundle::class, 'Google_Service_GamesConfiguration_LocalizedStringBundle');
