<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Iam
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Iam\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Deserialize;


/**
 * @property string $type
 * @property string $sid
 * @property string $friendlyName
 * @property string $description
 * @property \DateTime $dateCreated
 * @property string $createdBy
 * @property string $secret
 * @property string $status
 * @property string $policy
 * @property int $accessTokenTtl
 */
class OAuthAppInstance extends InstanceResource
{
    /**
     * Initialize the OAuthAppInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $sid Unique ID (sid) of the OAuth app
     */
    public function __construct(Version $version, array $payload, ?string $sid = null)
    {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'type' => Values::array_get($payload, 'type'),
            'sid' => Values::array_get($payload, 'sid'),
            'friendlyName' => Values::array_get($payload, 'friendly_name'),
            'description' => Values::array_get($payload, 'description'),
            'dateCreated' => Deserialize::dateTime(Values::array_get($payload, 'date_created')),
            'createdBy' => Values::array_get($payload, 'created_by'),
            'secret' => Values::array_get($payload, 'secret'),
            'status' => Values::array_get($payload, 'status'),
            'policy' => Values::array_get($payload, 'policy'),
            'accessTokenTtl' => Values::array_get($payload, 'access_token_ttl'),
        ];

        $this->solution = ['sid' => $sid ?: $this->properties['sid'], ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return OAuthAppContext Context for this OAuthAppInstance
     */
    protected function proxy(): OAuthAppContext
    {
        if (!$this->context) {
            $this->context = new OAuthAppContext(
                $this->version,
                $this->solution['sid']
            );
        }

        return $this->context;
    }

    /**
     * Delete the OAuthAppInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {

        return $this->proxy()->delete();
    }

    /**
     * Update the OAuthAppInstance
     *
     * @param IamV1AccountVendorOauthAppUpdateRequest $iamV1AccountVendorOauthAppUpdateRequest
     * @return OAuthAppInstance Updated OAuthAppInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(IamV1AccountVendorOauthAppUpdateRequest $iamV1AccountVendorOauthAppUpdateRequest): OAuthAppInstance
    {

        return $this->proxy()->update($iamV1AccountVendorOauthAppUpdateRequest);
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name)
    {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Iam.V1.OAuthAppInstance ' . \implode(' ', $context) . ']';
    }
}

